/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.generaltab;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.generaltab.VWSIMBeginDateTimePanel;
import filenet.sim.toolkit.designer.properties.generaltab.VWSIMEndDateTimePanel;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWSIMGeneralTab
extends JPanel
implements FocusListener,
ActionListener,
IVWSIMPropertyChangeListener {
    private VWToolbarBorder m_nameToolbarBorder = null;
    private VWTextField m_nameTextField = null;
    private VWToolbarBorder m_descriptionToolbarBorder = null;
    private JTextArea m_descriptionTextArea = null;
    private VWToolbarBorder m_beginDateTimeToolbarBorder = null;
    private VWSIMBeginDateTimePanel m_beginDateTimePanel = null;
    private VWToolbarBorder m_endDateTimeToolbarBorder = null;
    private VWSIMEndDateTimePanel m_endDateTimePanel = null;
    private VWToolbarBorder m_simulationToolbarBorder = null;
    private JCheckBox m_collectAnalysisDataCheckBox = null;
    private GridBagConstraints m_gridCons = null;
    private VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.m_gridCons = new GridBagConstraints();
        this.initScenarioNameControls();
        this.initDescriptionControls();
        this.initSimulateDataBeginDateTimeControls();
        this.initSimulateDataEndDateTimeControls();
        this.initSimulationControls();
        this.performChangeScenarioDefinition();
    }

    public void releaseReferences() {
        this.m_gridCons = null;
        this.m_nameToolbarBorder = null;
        this.m_nameTextField = null;
        this.m_descriptionToolbarBorder = null;
        this.m_descriptionTextArea = null;
        if (this.m_beginDateTimePanel != null) {
            this.m_beginDateTimePanel.releaseReferences();
            this.m_beginDateTimePanel = null;
        }
        if (this.m_endDateTimePanel != null) {
            this.m_endDateTimePanel.releaseReferences();
            this.m_endDateTimePanel = null;
        }
        if (this.m_collectAnalysisDataCheckBox != null) {
            this.m_collectAnalysisDataCheckBox.removeActionListener(this);
            this.m_collectAnalysisDataCheckBox = null;
        }
        this.m_simulationToolbarBorder = null;
        this.m_propertyData = null;
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (event.getSource().equals(this.m_nameTextField)) {
            try {
                this.m_propertyData.getScenarioDefinition().setName(this.m_nameTextField.getText());
                this.m_propertyData.setDirty();
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 102, this.m_propertyData);
            }
            catch (VWException ex) {
                VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
                VWDebug.logException(ex);
                this.m_nameTextField.setText(this.m_propertyData.getScenarioDefinition().getName());
            }
        } else if (event.getSource().equals(this.m_descriptionTextArea)) {
            this.m_propertyData.getScenarioDefinition().setDescription(this.m_descriptionTextArea.getText());
            this.m_propertyData.setDirty();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_collectAnalysisDataCheckBox)) {
            this.performCollectAnalysisDataCheckBox();
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: {
                this.performChangeScenarioDefinition();
            }
        }
    }

    private void initScenarioNameControls() {
        this.m_nameToolbarBorder = new VWToolbarBorder(VWSIMResource.s_scenarioName, 0);
        JPanel namePanel = this.m_nameToolbarBorder.getClientPanel();
        namePanel.setLayout(new GridLayout());
        this.m_nameTextField = new VWTextField(64);
        this.m_nameTextField.addFocusListener(this);
        namePanel.add(this.m_nameTextField);
        this.m_gridCons.gridx = 0;
        this.m_gridCons.gridy = 0;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 2;
        this.m_gridCons.gridheight = 1;
        this.add((Component)this.m_nameToolbarBorder, this.m_gridCons);
    }

    private void initDescriptionControls() {
        this.m_descriptionToolbarBorder = new VWToolbarBorder(VWSIMResource.s_description, 0);
        JPanel descriptionPanel = this.m_descriptionToolbarBorder.getClientPanel();
        descriptionPanel.setLayout(new GridLayout());
        this.m_descriptionTextArea = new JTextArea();
        this.m_descriptionTextArea.setLineWrap(true);
        this.m_descriptionTextArea.setWrapStyleWord(true);
        this.m_descriptionTextArea.setRows(5);
        this.m_descriptionTextArea.addFocusListener(this);
        descriptionPanel.add(new JScrollPane(this.m_descriptionTextArea));
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 1;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 0.2;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 2;
        this.m_gridCons.gridheight = 1;
        this.add((Component)this.m_descriptionToolbarBorder, this.m_gridCons);
    }

    private void initSimulateDataBeginDateTimeControls() {
        this.m_beginDateTimePanel = new VWSIMBeginDateTimePanel();
        this.m_beginDateTimePanel.init(this.m_propertyData);
        this.m_beginDateTimeToolbarBorder = new VWToolbarBorder(VWSIMResource.s_simulatedDataStartDateTime, 0, this.m_beginDateTimePanel);
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 1;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 1;
        this.m_gridCons.gridheight = 1;
        this.add((Component)this.m_beginDateTimeToolbarBorder, this.m_gridCons);
    }

    private void initSimulateDataEndDateTimeControls() {
        this.m_endDateTimePanel = new VWSIMEndDateTimePanel();
        this.m_endDateTimePanel.init(this.m_propertyData);
        this.m_endDateTimeToolbarBorder = new VWToolbarBorder(VWSIMResource.s_simulatedDataEndDateTime, 0, this.m_endDateTimePanel);
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 1;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 0.0;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 1;
        this.m_gridCons.gridheight = 1;
        this.add((Component)this.m_endDateTimeToolbarBorder, this.m_gridCons);
    }

    private void initSimulationControls() {
        this.m_simulationToolbarBorder = new VWToolbarBorder(VWSIMResource.s_processSimulatorOptions, 0);
        JPanel simulationPanel = this.m_simulationToolbarBorder.getClientPanel();
        simulationPanel.setLayout(new GridBagLayout());
        GridBagConstraints tempGBCons = new GridBagConstraints();
        tempGBCons.gridx = 0;
        tempGBCons.gridy = 0;
        tempGBCons.fill = 0;
        tempGBCons.weightx = 0.0;
        tempGBCons.weighty = 0.0;
        tempGBCons.anchor = 21;
        tempGBCons.gridwidth = 1;
        tempGBCons.gridheight = 1;
        tempGBCons.insets = new Insets(5, 5, 5, 5);
        this.m_collectAnalysisDataCheckBox = new JCheckBox(VWSIMResource.s_publishAnalysisData);
        this.m_collectAnalysisDataCheckBox.addActionListener(this);
        simulationPanel.add((Component)this.m_collectAnalysisDataCheckBox, tempGBCons);
        ++tempGBCons.gridx;
        tempGBCons.fill = 2;
        tempGBCons.weightx = 1.0;
        simulationPanel.add((Component)new JLabel(), tempGBCons);
        this.m_gridCons.gridx = 0;
        ++this.m_gridCons.gridy;
        this.m_gridCons.fill = 2;
        this.m_gridCons.weightx = 1.0;
        this.m_gridCons.weighty = 0.2;
        this.m_gridCons.anchor = 23;
        this.m_gridCons.gridwidth = 0;
        this.m_gridCons.gridheight = 1;
        this.add((Component)this.m_simulationToolbarBorder, this.m_gridCons);
    }

    private void performCollectAnalysisDataCheckBox() {
        this.m_propertyData.getScenarioDefinition().setCollectAnalysisData(this.m_collectAnalysisDataCheckBox.isSelected());
        this.m_propertyData.setDirty();
    }

    private void performChangeScenarioDefinition() {
        VWScenarioDefinition scenarioDefinition = this.m_propertyData.getScenarioDefinition();
        String name = scenarioDefinition.getName();
        if (name == null) {
            name = "";
        }
        this.m_nameTextField.setText(name);
        String description = scenarioDefinition.getDescription();
        if (description == null) {
            description = "";
        }
        this.m_descriptionTextArea.setText(description);
        this.m_collectAnalysisDataCheckBox.removeActionListener(this);
        this.m_collectAnalysisDataCheckBox.setSelected(scenarioDefinition.getCollectAnalyisData());
        this.m_collectAnalysisDataCheckBox.addActionListener(this);
    }
}

